---
type: index
tags:
  - "#layer/information"
  - "#status/stable"
  - "#function/observation"
---

# 20.0.2 - Field Classifications (index)

> Diagnostic classes of Field (transparent zone) and interface behavior, tied to anchors and SVA.

---

## Classification Framework

| Class | Description | Key Diagnostic |
|-------|-------------|----------------|
| [[Transparent Field (classification)]] | Clear interface exposure | Signal propagation within bounds |
| [[Masked Field (classification)]] | Hidden interface distortion | Concealed Voids or gates |
| [[Saturated Field (classification)]] | Capacity overload | Indistinguishable differences |
| [[Sparse Field (classification)]] | Under-resolution | Sub-ε differences |

Each classification provides:
- Technical and humane diagnostic criteria
- Scale-dependent manifestations
- Interface behavior patterns
- Operational tests

---

## Core References

Primitives:
- [[Field]]
- [[Void]]
- [[Structure]]
- [[Awareness]]

Anchors:
- [[ε — Difference Resolution Quantum (constant)]]
- [[c — Difference Propagation Limit (constant)]]

Modulators:
- [[λV — Void Resonance Threshold (Volozhina)]]
- [[ψA — Awareness Phase Coherence Anchor (Aiza)]]
- [[∇S — Structure Differentiation Gradient (Sarkisian)]]